C  
C------------------------------------------------------
C  
C     Problem:    LKIN_A3
C  
C     Date:       27.11.2006
C  
C------------------------------------------------------
C  
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C  
*     VARIABLE
      k11,  k12, k21, k22, D1, D2, y1, y2, t
C  
C------------------------------------------------------
C  
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C  
*     FUNCTION y1_t
      y1_t = -sqrt(k11)*k12*y1
C
*     FUNCTION y2_t
      y2_t = k11*k12*y1 - (k21 + 2*k22)*y2      
C  
C------------------------------------------------------
C  
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C  
*     FUNCTION y1_0
      y1_0 = D1 + 0.1*D2
C
*     FUNCTION y2_0
      y2_0 = 0          
C  
C------------------------------------------------------
C  
C   - Fitting criteria:
C  
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C  
C------------------------------------------------------
C  
C   - Constraints (if exist):
C  
C  *     FUNCTION g1
C      g1 = ...
C  
C------------------------------------------------------
C  
*     END
C  
C------------------------------------------------------
C
