C
C------------------------------------------------------
C
C     Problem:    LISA
C
C     Date:       28.05.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      s = 1.0E+8
      mue = 0.1327121E12/s**2
      g = 9.81
      fac = 60*60*24
C
C------------------------------------------------------
C
*     CONINT delta
      0.0   0.0
      25.0  1.0
      100.0 0.0
      200.0 1.0  
      410.0 0.0
C
C------------------------------------------------------
C
*     SPLINE alpha
      0.0   -35.0
      50.0  -75.0
      170.0 -40.0
      240.0 -85.0
      400.0 -20.0
      430.0 -55.0
C
C------------------------------------------------------
C
*     LININT beta
      0.0   235.0
      25.0  245.0
      220.0 115.0
      420.0 245.0
      450.0 230.0  
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Isp, umx, vx0, vy0, vz0, sx, sy, sz, vx, vy, vz, m, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION sx_t
      sx_t = vx/s*fac

*     FUNCTION sy_t
      sy_t = vy/s*fac

*     FUNCTION sz_t
      sz_t = vz/s*fac
C
*     FUNCTION vx_t
      umax = umx*1E-5
      r = sqrt(sx**2 + sy**2 + sz**2)
      ux = delta(t)*umax*cos(alpha(t))*cos(beta(t))
      vx_t = (-mue*sx/r**3 + ux/m)*fac
C
*     FUNCTION vy_t
      uy = delta(t)*umax*sin(alpha(t))*cos(beta(t))
      vy_t = (-mue*sy/r**3 + uy/m)*fac
C
*     FUNCTION vz_t
      uz = delta(t)*umax*sin(beta(t))
      vz_t = (-mue*sz/r**3 + uz/m)*fac
C
*     FUNCTION m_t
      m_t = -umax/(Isp*g)*delta(t)*fac
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION sx_0
      if (t.lt.1) then
        sx_0 = 0.367574127E+8/s
      else
        sx_0 = sx
      endif
C
*     FUNCTION sy_0
      if (t.lt.1) then
        sy_0 = -1.475905261E+8/s
      else
        sy_0 = sy
      endif
C
*     FUNCTION sz_0
      if (t.lt.1) then
        sz_0 = 0
      else
        sz_0 = sz
      endif
C
*     FUNCTION vx_0
      if (t.lt.1) then
        vx_0 = vx0
      else
        vx_0 = vx
      endif
C
*     FUNCTION vy_0
      if (t.lt.1) then
        vy_0 = vy0
      else
        vy_0 = vy
      endif
C
*     FUNCTION vz_0
      if (t.lt.1) then
        vz_0 = vz0
      else
        vz_0 = vz
      endif
C
*     FUNCTION m_0
      if (t.lt.1) then
        m_0 = 430.0
      else
        m_0 = m
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION sx_fit
      sx_fit = sx
C
*     FUNCTION sy_fit
      sy_fit = sy
C
*     FUNCTION sz_fit
      sz_fit = sz
C
*     FUNCTION vx_fit
      vx_fit = vx
C
*     FUNCTION vy_fit
      vy_fit = vy
C
*     FUNCTION vz_fit
      vz_fit = vz
C
*     FUNCTION m_fit
      m_fit = m
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


