C
C------------------------------------------------------
C
C     Problem:  LIN_VIS
C
C     Date:     10.5.1999
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind_M = 1..10
      ind_M1 = 1..9
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      Ge
      G(j), j in ind_M
      tau(j), j in ind_M
      omega_0, omega
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION E_p
      G1_p = Ge + sum(G(j)*(omega*tau(j))**2/(1.0 +
     /             (omega*tau(j))**2) , j in ind_M)
      omega_bar = omega/omega_0
      if (omega.gt.0) then
        G2_p = 0.67263 + 0.18859*omega_bar**0.24216
      else
        G2_p = 0.67263
      endif
      E_p = (G1_p - G2_p)/G2_p
C
*     FUNCTION E_pp
      G1_pp = sum(G(j)*omega*tau(j)/(1.0 +
     /             (omega*tau(j))**2) , j in ind_M)
      omega_bar = omega/omega_0
      if (omega.gt.0) then
        G2_pp = 0.49548*omega_bar**0.12651
      else
        G2_pp = 0
      endif
      if (G2_pp.le.0) then
        E_pp = G1_pp - G2_pp
      else
        E_pp = (G1_pp - G2_pp)/G2_pp
      endif
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION restr(i), i in ind_M1
      restr(i) = tau(i+1) - tau(i)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C







