C
C------------------------------------------------------
C
C     Problem:    LIN_SYS
C
C     Date:       22.11.2001
C
C------------------------------------------------------
C
*     PARAMETER 
      n = 15
      n1 = 14
C
C------------------------------------------------------
C
*     INDEX
      j
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
      ind1 = 1..n1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k
      y(i), i in ind
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:

*     FUNCTION y1_t
      y1_t = k - y(1)
C
*     FUNCTION y2_t
      y2_t = y(1) - 2*y(2) 
C
*     FUNCTION y3_t
      y3_t = y(2) - 3*y(3) 
C
*     FUNCTION y4_t
      y4_t = y(3) - 4*y(4) 
C
*     FUNCTION y5_t
      y5_t = y(4) - 5*y(5) 
C
*     FUNCTION y6_t
      y6_t = y(5) - 6*y(6) 
C
*     FUNCTION y7_t
      y7_t = y(6) - 7*y(7) 
C
*     FUNCTION y8_t
      y8_t = y(7) - 8*y(8) 
C
*     FUNCTION y9_t
      y9_t = y(8) - 9*y(9) 
C
*     FUNCTION y10_t
      y10_t = y(9) - 10*y(10) 
C
*     FUNCTION y11_t
      y11_t = y(10) - 11*y(11) 
C
*     FUNCTION y12_t
      y12_t = y(11) - 12*y(12) 
C
*     FUNCTION y13_t
      y13_t = y(12) - 13*y(13) 
C
*     FUNCTION y14_t
      y14_t = y(13) - 14*y(14) 
C
*     FUNCTION y15_t
      y15_t = y(14) - 15*y(15) 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y_0(i), i in ind
      y_0(i) = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind
      fit(i) = 10**(i/2)*y(i)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
