C
C-----------------------------------------------------
C
C     Problem:  LIN_KIN 
C
C     Date:     08.03.94
C
C-----------------------------------------------------
C
*     REAL CONSTANT
      A = 0.05
      B = 1
      C = 0.04
      R = 5000
C
C-----------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      K31, K41, TAU, V1, D, T0, T
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION C1
      AA = (A - K31)*(A - K41)/((A - B)*(A - C)*A)
      BB = (B - K31)*(B - K41)/((B - A)*(B - C)*B)
      CC = (C - K31)*(C - K41)/((C - A)*(C - B)*C)
      TERMA = DEXP(-A*(T - TAU))
      TERMB = DEXP(-B*(T - TAU))
      TERMC = DEXP(-C*(T - TAU))
      IF (T.LE.T0+TAU) THEN
        C1 = D/(V1*T0)*(AA*(1 - TERMA) + BB*(1 - TERMB) 
     /       + CC*(1 - TERMC))
      ELSE
        C1= D/(V1*T0)*(AA*(DEXP(A*T0) - 1)*TERMA
     /      + BB*(DEXP(B*T0) - 1)*TERMB 
     /      + CC*(DEXP(C*T0) - 1)*TERMC)
      ENDIF
C
*     FUNCTION Y2
      IF (T.LE.T0+TAU) THEN
        Y2 = D*R/T0*(T - TAU-B*C*AA/(K31 + K41)*(1 - TERMA)
     /      - A*C*BB/(K31 + K41)*(1 - TERMB) 
     /      - A*B*CC/(K31+K41)*(1 - TERMC))
      ELSE
        Y2 = D*R/T0*(T0 - B*C*AA/(K31 + K41)*(DEXP(A*T0) 
     /      - 1)*TERMA
     /            - A*C*BB/(K31 + K41)*(DEXP(B*T0) - 1)*TERMB
     /            - A*B*CC/(K31 + K41)*(DEXP(C*T0) - 1)*TERMC)
      ENDIF
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

