C
C------------------------------------------------------
C
C     Problem:    LIN_HYP2
C
C     Date:       19.1.2000
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, b, c, u, u_x, u_xx, f, f_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux1
      v1 = -1
      flux1 = v1*u
C
*     FUNCTION flux2
      v2 = -2
      flux2 = v2*u
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u1_t
      u1_t = f_x 
C
*     FUNCTION u2_t
      u2_t = f_x 
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u1_0
      if ((x.lt.-0.1).and.(x.gt.-0.3)) then
        u1_0 = exp(-1/(a*(x+b)**2*(x+c)**2))
      else
        u1_0 = 0
      endif
C
*     FUNCTION u2_0
      u2_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u1_left
      u1_left = 0
C
*     FUNCTION u2_left
      u2_left = 0.5*u
C
*     FUNCTION u2_right
      u2_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
c*     FUNCTION u_x_left
c      u_x_left = u
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in ind
c      if (x.lt.0) then
c        if ((x-t.lt.-0.1).and.(x-t.gt.-0.3)) then
c          fit(i) = exp(-1/(a*(x-t+b)**2*(x-t+c)**2))
c        else
c          fit(i) = 0
c        endif
c      else
c        if ((0.5*(x-2*t).lt.-0.1).and.(0.5*(x-2*t).gt.-0.3)) then
c          fit(i) = 0.5*exp(-1/(a*(0.5*(x-2*t)+b)**2
c     /                               *(0.5*(x-2*t)+c)**2))   
c        else
c          fit(i) = 0
c        endif
c      endif
      fit(i) = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
