C
C------------------------------------------------------
C
C     Problem:    LIN_CMP3
C
C     Date:       9.5.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      TLAGE = 0.2
      TLAG1 = 0.05
      P1    = 4.5
      P2    = 23.4372
      D     = 100.0
      YINF  = 80.001
      VC    = 4.5
      F     = 16.66667
      k01   = 1.20
      k1e   = 1000
      k31   = 10000
      k41   = 0.05
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      B1, B2, B3, TT
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION C
      A1  = K01*(K31-K01)*(K41-K01)/((B1-K01)*(B2-K01)*(B3-K01))
      A2  = K01*(K31-B1)*(K41-B1)/((K01-B1)*(B2-B1)*(B3-B1))
      A3  = K01*(K31-B2)*(K41-B2)/((K01-B2)*(B1-B2)*(B3-B2))
      A4  = -(A1 + A2 + A3)
      P1A = D*F/VC
      C24 = P1A*(A1*EXP(-K01*(24-TLAG1)) + A2*EXP(-B1*(24-TLAG1))
     /         + A3*EXP(-B2*(24-TLAG1)) + A4*EXP(-B3*(24-TLAG1)))
      P1A = (D + C24)*F/VC
      C48 = P1A*(A1*EXP(-K01*(48-TLAG1)) + A2*EXP(-B1*(48-TLAG1))
     /         + A3*EXP(-B2*(48-TLAG1)) + A4*EXP(-B3*(48-TLAG1)))
      IF (TT.GT.48) THEN
        T  = TT - 48
        D1 = C48
      ELSE
        IF (TT.GT.24) THEN
          T  = TT - 24
          D1 = C24
        ELSE
          T  = TT
          D1 = 0
        ENDIF
      ENDIF
      P1A = (D + D1)*F/VC
      C = P1A*(A1*EXP(-K01*(T-TLAG1)) + A2*EXP(-B1*(T-TLAG1))
     /       + A3*EXP(-B2*(T-TLAG1)) + A4*EXP(-B3*(T-TLAG1)))
      C = LOG10(ABS(C))
C
*     FUNCTION Y
      TLAG = TLAG1 + TLAGE
      P2A  = K1E*YINF*F
      Y24  = P2A*(A1/K01*(1-EXP(-K01*(24-TLAG))) 
     /          + A2/B1*(1-EXP(-B1*(24-TLAG)))
     /          + A3/B2*(1-EXP(-B2*(24-TLAG)))
     /          + A4/B3*(1-EXP(-B3*(24-TLAG))))
      Y48 = P2A*(A1/K01*(1-EXP(-K01*(48-TLAG))) 
     /          + A2/B1*(1-EXP(-B1*(48-TLAG)))
     /          + A3/B2*(1-EXP(-B2*(48-TLAG)))
     /          + A4/B3*(1-EXP(-B3*(48-TLAG))))
      IF (TT.GT.48) THEN
        T = TT - 48
      ELSE
        IF (TT.GT.24) THEN
          T   = TT - 24
          Y48 = 0
        ELSE
          T   = TT
          Y24 = 0
          Y48 = 0
        ENDIF
      ENDIF
      Y = P2A*(A1/K01*(1-EXP(-K01*(T-TLAG))) 
     /       + A2/B1*(1-EXP(-B1*(T-TLAG)))
     /       + A3/B2*(1-EXP(-B2*(T-TLAG)))
     /       + A4/B3*(1-EXP(-B3*(T-TLAG))))
     /       + Y24 + Y48
      Y = LOG10(ABS(Y))
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




