C
C------------------------------------------------------
C
C     Problem:    LIN_CMP1
C
C     Date:       08.05.1996
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      eps = 0.00001
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      D, b1, b2, k12, k13, k21, t_lag, t
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y
      if (b1.ne.b2) then
        a2 = -(k13 + b1)/(b1 - b2)
      else
        a2 = 0
      endif
      a1 = -1 - a2
      if (t.ge.t_lag) then
        y = D*(a1*exp(b1*(t-t_lag)) + a2*exp(b2*(t-t_lag)) + 1)
      else
        y = 0
      endif
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = b1*b2 - k13*k21
C
*     FUNCTION g2
      g2 = (b1 + b2) + (k12 + k13 + k21)
C 
*     FUNCTION g3
      g3 = b2 - b1 - eps
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


