C
C------------------------------------------------------
C
C     Problem:    LIN_ADV
C
C     Date:       5.8.1999
C
C------------------------------------------------------
C 
*     SET OF INDICES
      ind = 1..9
C
C------------------------------------------------------
C      
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, z, delta, alpha, u, u_x, u_xx, f, f_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux 
      flux = -0.1*u
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u_t
      u_t = f_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u_0
      beta = log(2)/(36*delta**2)
      u_0 = 0
      if ((x.ge.-0.8).and.(x.le.-0.6)) then
        G1 = exp(-beta*(x-z+delta)**2)
        G2 = exp(-beta*(x-z-delta)**2)
        G3 = exp(-beta*(x-z)**2)
        u_0 = (G1 + G2 + 4*G3)/6
      else
      if ((x.ge.-0.4).and.(x.le.-0.2)) then
        u_0 = 1
      else
      if ((x.ge.0).and.(x.le.0.2)) then
        u_0 = 1 - abs(10*(x - 0.1))
      else
      if ((x.ge.0.4).and.(x.le.0.6)) then
        w1 = 1 - alpha**2*(x - a + delta)**2
        if (w1.lt.0) then
          w1 = 0
        endif
        w2 = 1 - alpha**2*(x - a - delta)**2
        if (w2.lt.0) then
          w2 = 0
        endif
        w3 = 1 - alpha**2*(x - a)**2
        if (w3.lt.0) then
          w3 = 0
        endif
        F1 = sqrt(w1)
        F2 = sqrt(w2)
        F3 = sqrt(w3)
        u_0 = (F1 + F2 + 4*F3)/6
      endif
      endif
      endif
      endif 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_left
c      u_left = 0
C
c*     FUNCTION u_right
c      u_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in ind
      fit(i) = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
