C
C------------------------------------------------------
C
C     Problem:    LIFE
C
C     Date:       22.07.2004
C
C------------------------------------------------------
C           
*     REAL CONSTANT
      a = 2.7
      mu = 2.62
      b = a - 1
      c = a/2 + 1
      d = a - 2
      f = a/2 + 2
C
C------------------------------------------------------
C                
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      p, q, x
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION life 
      Aq = 2*mu/(a*q)
      Bp = 1 + p         
      t = 1/(Bp*Aq**p)
      u = (x**b - x**(-c))**2
      v = b*x**d + c*x**(-f)
      life = t*(u/v)**(-p)         
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

