C
C------------------------------------------------------
C
C     Problem:    LEPS
C
C     Date:       30.03.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      beta = 1.03613
      dbond = 2.1163
      k = 2.07226
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      De, ma, mb, y1, y2, y3, y4, y5, y6, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = y4/ma
C
*     FUNCTION y2_t
      y2_t = y5/mb
C
*     FUNCTION y3_t
      mc = 0.5*ma
      y3_t = y6/mc
C
*     FUNCTION y4_t
      dx = y1 - y2                
      dy = y2 - y3            
      e1 = exp(-beta*(abs(dx)-dbond))
      e2 = exp(-beta*(abs(dy)-dbond))
      k1 = k*De
      v1 = -k1*(e1*e1-e1)
      v2 = -k1*(e2*e2-e2)
      d4 = -v1*abs(dx)/dx
      y4_t = d4
C
*     FUNCTION y5_t
      d6 = v2*abs(dy)/dy
      y5_t = - d4 - d6
C
*     FUNCTION y6_t
      d6 = v2*abs(dy)/dy
      y6_t = d6
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = -7.5
C
*     FUNCTION y2_0
      y2_0 = 0
C
*     FUNCTION y3_0
      y3_0 = 1.807121
C
*     FUNCTION y4_0
      y4_0 = 0.08
C
*     FUNCTION y5_0
      y5_0 = 0
C
*     FUNCTION y6_0
      y6_0 = 0.06
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y4_fit = y4
C
*     FUNCTION y5_fit
      y5_fit = y5
C
*     FUNCTION y6_fit
      y6_fit = y6
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


