C
C------------------------------------------------------
C
C     Problem:    LASER
C
C     Date:       02.10.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k = 1.3806E-16 
      h = 6.6261E-27 
      N = 1000 
      Np = 1E10 
      tmp = 293  
      kaAB = 1.1E7 
      kaBC = 1.1E7 
      kaAC = 1.1E7  
      ksCA = 1.1E7  
      ksCB = 1.1E7 
      ksBA = 1.1E7 
      kiCA = 0.1E7 
      kiCB = 0.2E7
      kiBA = 0.3E7 
      kdAB = 1E9  
      kdBC = 1E7  
      kdAC = 1E9 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      EAs, EBs, ECs, NA, NB, NC, NAB, NAC, NBC, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION NA_t
      NAt = -kaAC*NAC*NA - kaAB*NAB*NA + ksCA*NC 
     /       + ksBA*NB + kiCA*NAC*NC + kiBA*NAB*NB
      NA_t = NAt
C
*     FUNCTION NB_t
      NBt = -kaBC*NBC*NB + kaAB*NAB*NA + ksCB*NC
     /       - ksBA*NB - kiBA*NAB*NB + kiCB*NBC*NC
      NB_t = NBt
C
*     FUNCTION NC_t
      NC_t = -NAt - NBt
C
*     FUNCTION NAB_t
      NAB_t = -kaAB*NAB*NA + ksBA*NB + kiBA*NAB*NB - kdAB*NAB
C
*     FUNCTION NAC_t
      pumpAC = Np
      NAC_t = pumpAC - kaAC*NAC*NA + ksCA*NC + kiCA*NAC*NC
     /        - kdAC*NAC
C
*     FUNCTION NBC_t
      NBC_t = -kaBC*NBC*NB + ksCB*NC + kiCB*NBC*NC - kdBC*NBC
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION NA_0
      EA = EAs*1E-11
      EB = EBs*1E-11
      EC = ECs*1E-11
      gEA = exp(-EA/(k*tmp)) 
      gEB = exp(-EB/(k*tmp)) 
      gEC = exp(-EC/(k*tmp))
      bf = gEA + gEB + gEC 
      NA_0 = N*gEA/bf
C
*     FUNCTION NB_0
      NB_0 = N*gEB/bf
C
*     FUNCTION NC_0
      NC_0 = N*gEC/bf
C
*     FUNCTION NAB_0
      NAB_0 = 0
C
*     FUNCTION NAC_0
      NAC_0 = 0
C
*     FUNCTION NBC_0
      NBC_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION NA_fit
      NA_fit = NA
C
*     FUNCTION NB_fit
      NB_fit = NB
C
*     FUNCTION NC_fit
      NC_fit = NC
C
*     FUNCTION NAB_fit
      NAB_fit = NAB
C
*     FUNCTION NAC_fit
      NAC_fit = NAC
C
*     FUNCTION NBC_fit
      NBC_fit = NBC
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
