C
C------------------------------------------------------
C
C     Problem:    LAPLACE
C
C     Date:       05.07.97
C
C------------------------------------------------------
C
*     PARAMETER
      n = 20
C
C------------------------------------------------------
C
*     INDEX
      j
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
      ind10=1..10
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      h = 1/(n-1)
      eps = 1/(24*h**2)
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      b
      u(i), i in ind
      u_x(i), i in ind
      u_xx(i), i in ind
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = U
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t(i), i in ind
      if (i.eq.1) then
        ut = u_xx(1) + (-308*u(2) + 428*u(3) 
     /               - 312*u(4) + 122*u(5) - 20*u(6))*eps
      else
      if (i.eq.2) then
        ut = u_xx(2) + (-30*u(2) - 8*u(3) 
     /               + 28*u(4) - 12*u(5) + 2*u(6))*eps
      else
      if (i.lt.n-1) then
        ut = u_xx(i) + (-2*u(i-2) + 32*u(i-1) - 60*u(i) 
     /                + 32*u(i+1) - 2*u(i+2))*eps
      else
      if (i.eq.n-1) then
        ut = u_xx(i) + (-30*u(i) - 8*u(i-1) 
     /                + 28*u(i-2) - 12*u(i-3) + 2*u(i-4))*eps
      else
        ut = u_xx(i) + (-308*u(i-1) + 428*u(i-2) 
     /               - 312*u(i-3) + 122*u(i-4) - 20*u(i-5))*eps
      endif
      endif
      endif
      endif
      u_t(i) = ut
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0(i), i in ind
      u_0(i) = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_left(i), i in ind
      u_left(i) = 0
C
*     FUNCTION u_right(i), i in ind
      u_right(i) = sinh(b)*sin(b*(i-1)*h)
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C*     FUNCTION UXL
C      UXL = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit(i), i in ind
      u_fit(i) = u(i) 
c      u_fit(i) = sinh(pi*x)*sin(pi*(i-1)*h)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
