C
C------------------------------------------------------
C
C     Problem:    LANDING
C
C     Date:       15.03.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      m = 115000
      omega = 7.27E-5
      cD0 = 0.017
      g0 = 9.80665
      beta = 1/6900
      r0 = 6.371E+6
      rho0 = 1.2495
C
C------------------------------------------------------
C
*     LININT mu
      0.0      0.08
      150.0    0.1
      220.0    0.09
      400.0    0.1
      450.0    0.8
C
*     LININT CL
      0.0      0.8
      150.0    0.35
      220.0    0.4
      300.0    0.2
      450.0    0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k, c, F
      v, gamma, chi, h, lambda, theta, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION v_t
      cD = cD0 + k*CL(t)**2
      r = r0 + h
      rho = rho0*EXP(-beta*h)
      g = g0*(r0/r)**2
      q = rho*v**2/c
      D = q*F*cD
      v_t = -D/m - g*sin(gamma) 
     /  + omega**2*cos(lambda)*(sin(gamma)*cos(lambda) 
     /                      - cos(gamma)*sin(chi)*sin(lambda))*r 
C
*     FUNCTION gamma_t
      L = q*F*CL(t)
      gamma_t = L*cos(mu(t))/(m*v) - (g - v)*cos(gamma)/r
     /  + 2*omega*cos(chi)*cos(lambda) + omega**2*cos(lambda)
     /       *(sin(gamma)*sin(lambda)*sin(chi) 
     /           + cos(gamma)*cos(lambda))*r/v 
C
*     FUNCTION chi_t
      chi_t = L*sin(mu(t))/(m*v*cos(gamma)) 
     /                    - cos(gamma)*cos(chi)*tan(lambda)*v/r
     /  + 2*omega*(sin(chi)*cos(lambda)*tan(gamma) - sin(lambda))
     /  - omega**2*sin(gamma)*cos(lambda)*cos(chi)*r/(v*cos(gamma)) 
C
*     FUNCTION h_t
      h_t = v*sin(gamma)
C
*     FUNCTION lambda_t
      lambda_t = cos(gamma)*sin(chi)*v/r
C
*     FUNCTION theta_t
      theta_t = cos(gamma)*cos(chi)*v/(r*cos(lambda))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION v_0
      v_0 = 2150.545
C
*     FUNCTION gamma_0
      gamma_0 = 0.152018
C
*     FUNCTION chi_0
      chi_0 = 2.2689
C
*     FUNCTION h_0
      h_0 = 33900
C
*     FUNCTION lambda_0
      lambda_0 = 0.865142
C
*     FUNCTION theta_0
      theta_0 = 0.198091
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION v_fit
      v_fit = v
C
*     FUNCTION gamma_fit
      gamma_fit = gamma
C
*     FUNCTION chi_fit
      chi_fit = chi
C
*     FUNCTION h_fit
      h_fit = h
C
*     FUNCTION lambda_fit
      lambda_fit = lambda
C
*     FUNCTION theta_fit
      theta_fit = theta
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


