C
C------------------------------------------------------
C
C     Problem:    KS_FUNC
C
C     Date:       08.01.2004
C
C------------------------------------------------------
C                                            
*     REAL CONSTANT
      rho = 100
C
C------------------------------------------------------
C                                                  
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      k1, k2, D, t
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y_max
      y1 = D*exp(-k1*t)
      y2 = k1*D/(k1-k2)*(exp(-k2*t) - exp(-k1*t))   
      y3 = t/30
      if (y1.gt.y2) then 
        y_max = y1
      else
        y_max = y2
      endif    
      if (y_max.lt.y3) then 
        y_max = y3
      endif    
C
*     FUNCTION KS_max
      KS_max = log(exp(rho*y1) + exp(rho*y2) 
     /         + exp(rho*y3))/rho 
C
*     FUNCTION y_min
      if (y1.lt.y2) then 
        y_min = y1
      else
        y_min = y2
      endif    
      if (y_min.gt.y3) then 
        y_min = y3
      endif    
C
*     FUNCTION KS_min
      KS_min = -log(exp(-rho*y1) + exp(-rho*y2) 
     /         + exp(-rho*y3))/rho 
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
