C
C------------------------------------------------------
C
C     Problem:    KLADYN
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      G=3000
      VL=45
      VG=5   
      RTH = 0.03
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      KLA, TF, TE, CG, CL, CF, CE, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CGP
      TG=VG/G 
      TH=T*TG 
      CGP=(1-CG)-KLA*TG*(VL/VG)*RTH*(CG-CL)   
C
*     FUNCTION CLP
      CLP=KLA*TG*(CG-CL)  
C
*     FUNCTION CFP
      CFP=(CL-CF)/(TF/TG) 
C
*     FUNCTION CEP
      CEP=(CF-CE)/(TE/TG) 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CG_0
      CG_0=0
C
*     FUNCTION CL_0
      CL_0=0
C
*     FUNCTION CF_0
      CF_0=0
C
*     FUNCTION CE_0
      CE_0=0
C
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CG_fit
      CG_fit=CG
C
*     FUNCTION CL_fit
      CL_fit=CL
C
*     FUNCTION CF_fit
      CF_fit=CF  
C
*     FUNCTION CE_fit
      CE_fit=CE   
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
