C
C------------------------------------------------------
C
C     Problem:    KIN_PRO
C
C     Date:       06.09.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      SUC0=90.929
      GLU0=0
      FRU0=0
      AMON0=0.525
      CIT0=0
      ZA0=1
      ZB0=0
      ZC0=0
      ZD0=0
      X0=0.1  
      kgluA=2.95E-02
      K_gluA=3.42E+00
      kgluB=2.35E-01
      K_gluB=4.08E+00
      kfruA=2.80E-01
      K_fruA=2.63E+01
      kfruB=1.00E-02
      K_fruB=5.59E-01
      kamonA=7.72E-01
      K_amonA=1.79E+01
      kcitA=1.00E-07
      K_citAG=1.00E-07
      K_citAF=1.21E+00
      kcitB=1.17E-01
      K_citBG=1.62E+00
      K_citBF=1.41E+00
      K_AG=1.02E+00
      K_AF=1.28E+00
      K_AA=1.87E+00
      K_BG=1.00E-07
      K_BF=3.99E+00
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      kh, k1, k2, ka, k3, k4, kb
      SUC, GLU, FRU, AMON, CIT, ZA, ZB, ZC, ZD, X
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION SUC_t
      Rh=kh*SUC
      SUC_t=-2*Rh
C
*     FUNCTION GLU_t
      RgluA=kgluA*(GLU/(GLU+K_gluA))
      RgluB=kgluB*(GLU/(GLU+K_gluB))      
      GLU_t=Rh-(RgluA*ZA+RgluB*ZB)*X
C
*     FUNCTION FRU_t
      RfruA=kfruA*(FRU/(FRU+K_fruA))
      RfruB=kfruB*(FRU/(FRU+K_fruB))  
      FRU_t=Rh-(RfruA*ZA+RfruB*ZB)*X
C
*     FUNCTION AMON_t
      Ramon=kamonA*(AMON/(AMON+K_amonA))
      AMON_t=-Ramon*ZA*X
C
*     FUNCTION CIT_t
      RcitA=kcitA*(GLU/(GLU+K_citAG))*(FRU/(FRU+K_citAF))
      RcitB=kcitB*(GLU/(GLU+K_citBG))*(FRU/(FRU+K_citBF))
      CIT_t=(RcitA+RcitB)*X
C
*     FUNCTION ZA_t
      u1=k1*ZA
      u2=k2*ZA
      mia=ka*(GLU/(GLU+K_AG))*(FRU/(FRU+K_AF))*(AMON/(AMON+K_AA))
      mib=kb*(GLU/(GLU+K_BG))*(FRU/(FRU+K_BF))     
      mi=mia*ZA+mib*ZB
      ZA_t=-u1-u2+mia*ZA-mi*ZA
C
*     FUNCTION ZB_t   
      u3=k3*ZB
      ZB_t=u1-u3+mib*ZB-mi*ZB
C
*     FUNCTION ZC_t
      u4=k4*ZC
      ZC_t=u2+u3-u4-mi*ZC
C
*     FUNCTION ZD_t
      ZD_t=u4-mi*ZD
C
*     FUNCTION X_t
      X_t=mi*X
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION SUC_0
      SUC_0=SUC0
C
*     FUNCTION GLU_0
      GLU_0=GLU0
C
*     FUNCTION FRU_0
      FRU_0=FRU0
C
*     FUNCTION AMON_0
      AMON_0=AMON0
C
*     FUNCTION CIT_0
      CIT_0=CIT0
C
*     FUNCTION ZA_0
      ZA_0=ZA0
C
*     FUNCTION ZB_0
      ZB_0=ZB0
C
*     FUNCTION ZC_0
      ZC_0=ZC0
C
*     FUNCTION ZD_0
      ZD_0=ZD0
C
*     FUNCTION X_0
      X_0=X0        
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION SUC_fit
      SUC_fit=SUC
C
*     FUNCTION GLU_fit
      GLU_fit=GLU
C
*     FUNCTION FRU_fit
      FRU_fit=FRU
C
*     FUNCTION AMON_fit
      AMON_fit=AMON
C
*     FUNCTION CIT_fit
      CIT_fit=CIT
C
*     FUNCTION ZA_fit
      ZA_fit=ZA
C
*     FUNCTION ZB_fit
      ZB_fit=ZB
C
*     FUNCTION ZC_fit
      ZC_fit=ZC
C
*     FUNCTION ZD_fit
      ZD_fit=ZD
C
*     FUNCTION X_fit
      X_fit=X      
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




