C
C------------------------------------------------------
C
C     Problem:    KILN
C
C     Date:       12.5.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      r1 = 4
      q1 = 4
      r2 = -1
      q2 = 1
      pi = 3.1415926535
      eta = -1
      g = 1
C
C------------------------------------------------------
C
*     MACRO u
      u = u1 + u2*t + u3*t**2 + u4*t**3 + u5*t**4 + u6*t**5
     /    + u7*t**6 + u8*t**7 + u9*t**8 + u10*t**9

C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      u1, u2, u3, u4, u5, u6, u7, u8, u9, u10
      y, y_x, y_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION y_t
      kappa = r1 + r2*y
      kappa_x = r2*y_x
      tau = q1 + q2*y
      q = (eta*(q1 + 2*q2) 
     /    + pi**2*(r1 + 2*r2))*exp(eta*t)*cos(pi*x)
     /    - r2*pi**2*exp(2*eta*t) 
     /    + (2*r2*pi**2 + eta*q2)*exp(2*eta*t)*cos(pi*x)**2
      y_t = (kappa*y_xx + kappa_x*y_x + q)/tau 
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION y_0
      y_0 = 2 + cos(pi*x)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_left
c      u_left = 0
C
c*     FUNCTION u_right
c      u_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
*     FUNCTION y_x_left
      kappa = r1 + r2*y
      y_x_left = g*(y - u)/kappa
C
*     FUNCTION y_x_right
      y_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      yd = 2 - exp(eta*t)
      fit = y - yd
C
*     FUNCTION fit_u
      fit_u = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
