C
C------------------------------------------------------
C
C     Problem:    KIDNEY
C
C     Date:       16.7.1999
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, c, d, y1, y2, y3, y4, y5, alpha, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = a*y1*(y3 - y1)
C
*     FUNCTION y2_t
      y2_t = -a*(y3 - y1)
C
*     FUNCTION y3_t
      y3_t = (b - c*(y3 - y5) - a*y3*(y3 - y1))/y4
C
*     FUNCTION y4_t
      y4_t = a*(y3 - y1)
C
*     FUNCTION y5_t
      y5_t = -c*(y5 - y3)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 1
C
*     FUNCTION y2_0
      y2_0 = 1
C
*     FUNCTION y3_0
      y3_0 = 1
C
*     FUNCTION y4_0
      y4_0 = -10
C
*     FUNCTION y5_0
      y5_0 = alpha
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y4_fit = y4
C
*     FUNCTION y5_fit
      y5_fit = y5
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


