C
C------------------------------------------------------
C
C     Problem:    KEPLER
C
C     Date:       07.02.99
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      alpha, beta, q1, q2, p1, p2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION q1_t
      r = sqrt(q1**2 + q2**2)
      q1_t = p1
C
*     FUNCTION q2_t
      q2_t = p2
C
*     FUNCTION p1_t
      p1_t = -(1/r**2 + alpha*1.5/r**4)/r*q1
C
*     FUNCTION p2_t
      p2_t = -(1/r**2 + alpha*1.5/r**4)/r*q2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION q1_0
      q1_0 = 1 - beta
C
*     FUNCTION q2_0
      q2_0 = 0
C
*     FUNCTION p1_0
      p1_0 = 0
C
*     FUNCTION p2_0
      p2_0 = sqrt((1 + beta)/(1 - beta))
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION q1_fit
      q1_fit = q1
C
*     FUNCTION q2_fit
      q2_fit = q2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
