C
C------------------------------------------------------
C
C     Problem:    KATALY2
C
C     Date:       16.12.1999
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1,k2,k3,k4,k5,k6,k7,k8,k9,k10,k11,k12,k13
      k14,k15,k16,k17,k18,k19
      MH1,MH2,MH3,MH4,MH5,MH6,MH7,MH8,MH9,MH10,MH11,MH12
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C      
*     FUNCTION MH1_t 
      MH1_t=k1*MH7
C
*     FUNCTION MH2_t 
      MH2_t=k2*MH7+k3*MH8
C
*     FUNCTION MH3_t 
      MH3_t=k4*MH9
C
*     FUNCTION MH4_t 
      MH4_t= k5*MH10
C
*     FUNCTION MH5_t 
      MH5_t=k7*MH11+k8*MH12 
C
*     FUNCTION MH6_t 
      MH6_t=k9*MH12
C
*     FUNCTION MH7_t 
      MH7_t=-(k1+k2)*MH7+k10*MH8
C
*     FUNCTION MH8_t 
      MH8_t=-(k3+k10+k12+k18)*MH8+k11*MH9+k19*MH10
C
*     FUNCTION MH9_t 
      MH9_t=-(k4+k11+k14)*MH9+k12*MH8+k13*MH10
C
*     FUNCTION MH10_t 
      MH10_t=-(k5+k13+k16+k19)*MH10+k14*MH9+k15*MH11+k18*MH8
C
*     FUNCTION MH11_t 
      MH11_t=-(k6+k7+k15+k17)*MH11+k16*MH10 
C
*     FUNCTION MH12_t 
      MH12_t=k17*MH11-(k8+k9)*MH12
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION MH1_0
      MH1_0=0
C
*     FUNCTION MH2_0
      MH2_0=0   
C
*     FUNCTION MH3_0
      MH3_0=0
C
*     FUNCTION MH4_0
      MH4_0=0
C
*     FUNCTION MH5_0
      MH5_0=0
C
*     FUNCTION MH6_0
      MH6_0=0
C
*     FUNCTION MH7_0
      MH7_0=0
C
*     FUNCTION MH8_0
      MH8_0=0.333   
C
*     FUNCTION MH9_0
      MH9_0=0.020
C
*     FUNCTION MH10_0
      MH10_0=0.432
C
*     FUNCTION MH11_0
      MH11_0=0.215
C
*     FUNCTION MH12_0
      MH12_0=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION MH1_fit
      MH1_fit=MH1
C
*     FUNCTION MH2_fit
      MH2_fit=MH2
C
*     FUNCTION MH3_fit
      MH3_fit=MH3
C
*     FUNCTION MH4_fit
      MH4_fit=MH4
C
*     FUNCTION MH5_fit
      MH5_fit=MH5
C
*     FUNCTION MH6_fit
      MH6_fit=MH6
C
*     FUNCTION MH7_fit
      MH7_fit=MH7
C
*     FUNCTION MH8_fit
      MH8_fit=MH8
C
*     FUNCTION MH9_fit
      MH9_fit=MH9
C
*     FUNCTION MH10_fit
      MH10_fit=MH10
C
*     FUNCTION MH11_fit
      MH11_fit=MH11
C
*     FUNCTION MH12_fit
      MH12_fit=MH12
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
