C
C------------------------------------------------------
C
C     Problem:    KATALY1
C
C     Date:       16.12.1999
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..9
C
C------------------------------------------------------
C
*     REAL CONSTANT
      u4 = 1.9613E-7
      u5 = 2.6355E-7
      u6 = 1.3382E-7
      u7 = 0.63506E-7
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      u1, u2, u3, u8, u9, u10, u11, u12
      u13, u14, u15, u16, u17
      x(i), i in ind
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dx1_dt 
      dx1_dt = u1*x(5)
C
*     FUNCTION dx2_dt 
      dx2_dt= u2*x(5)+u3*x(6)
C
*     FUNCTION dx3_dt 
      dx3_dt= u4*x(6)+u5*x(7)
C
*     FUNCTION dx4_dt 
      dx4_dt= u6*x(7)+u7*x(8)
C
*     FUNCTION dx5_dt 
      dx5_dt= -u1*x(5)-u2*x(5)-u8*x(5)+u13*x(6)-u14*x(5)
C
*     FUNCTION dx6_dt 
      dx6_dt= -u3*x(6)-u4*x(6)-u9*x(6)-u13*x(6)+u8*x(5)+
     /         u12*x(7)-u15*x(6)
C
*     FUNCTION dx7_dt 
      dx7_dt= -u5*x(7)-u6*x(7)-u10*x(7)-u12*x(7)-
     /         u16*x(7)+u11*x(8)+u9*x(6)
C
*     FUNCTION dx8_dt 
      dx8_dt= -u7*x(8)-u11*x(8)+u10*x(7)-u17*x(8)
C
*     FUNCTION dx9_dt 
      dx9_dt= u14*x(5)+u15*x(6)+u16*x(7)+u17*x(8)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0(i), i in ind
      if (i.eq.5) then
        x_0(i) = 1
      else
        x_0(i) = 0
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit(i), i in ind
      x_fit(i) = x(i)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

