C
C------------------------------------------------------
C
C     Problem:    JUXTA
C
C     Date:       2/15/2004
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, y1, y2, y3, y4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -k1*y1*y4*(1.0 - y2 - y3)
C
*     FUNCTION y2_t
      y2_t = k2*(1.0 - y2 - y3)
C
*     FUNCTION y3_t
      y3_t = k3*y2*y4
C
*     FUNCTION y4_t
      y4_t = k3*k4*y2*y4 + k1*k4*y1*y4*(1.0 - y2 - y3)
C
C------------------------------------------------------
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 0.24
C
*     FUNCTION y2_0
      y2_0 = 0.0
C
*     FUNCTION y3_0
      y3_0 = 0.5
C
*     FUNCTION y4_0
      y4_0 = 0.5
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      fit = 100.0*(y1_0 - y1)/y1_0 + 55
C
*     FUNCTION plot1
      plot1 = y1
C
*     FUNCTION plot2
      plot2 = y2
C
*     FUNCTION plot3
      plot3 = y3
C
*     FUNCTION plot4
      plot4 = y4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION g
c      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
