C
C------------------------------------------------------
C
C     Problem:    JONTO
C
C     Date:       12.2.1997
C
C------------------------------------------------------
C
*     PARAMETER
      nbreaks = 3
      nres = 2
C
C------------------------------------------------------
C
*     INDEX
      i
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind_breaks = 1..nbreaks
      ind_res = 1..nres
C
C------------------------------------------------------
C
*     REAL CONSTANT
      eps   = 0.01
      c0    = 1
      A     = 0.5
      x1    = 0.1
      x2    = 0.11
      x3    = 0.21
      V     = 1 
      k12   = 10
      k21   = 1
      k32   = 1
      D1    = 0.0003
      D2    = 0.002
      D3    = 0.1
      alpha = 1/250
C
C------------------------------------------------------
C
*     MACRO Vm
      Vm = 0    
      IF (t.GE.tbreak(1)) THEN
        i=2  
 1000   CONTINUE     
        IF ((t.GE.tbreak(i-1)).AND.(t.LT.tbreak(i))) THEN
          Vm = 1
        ENDIF
        i=i+2
        IF ((Vm.LT.1).AND.(i.LE.nbreaks)) THEN
          GOTO 1000
        ENDIF
      ENDIF
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      z
      tbreak(j), j IN ind_breaks
      c, c_x, c_xx
      y1
      x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c1_p
      c1_p = D1*c_xx - z*c_x*alpha*Vm/x3
C
*     FUNCTION c2_p
      c2_p = D2*c_xx - z*c_x*alpha*Vm/x3
C
*     FUNCTION c3_p
      c3_p = D3*c_xx - z*c_x*alpha*Vm/x3
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c1_0
      IF (t.LT.tbreak(1)/2) THEN
        c1_0 = c0
      ELSE
        c1_0 = c
      ENDIF
C 
*     FUNCTION c2_0
      IF (t.LT.tbreak(1)/2) THEN
        c2_0 = 0.0
      ELSE
        c2_0 = c
      ENDIF
C 
*     FUNCTION c3_0
      IF (t.LT.tbreak(1)/2) THEN
        c3_0 = 0.0
      ELSE
        c3_0 = c
      ENDIF
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C 
*     FUNCTION y1_p
      y1_p = -k12*y1 - A*D3*c_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION y1_0
      IF (t.LT.tbreak(1)/2) THEN
        y1_0 = 0
      ELSE
        y1_0 = y1
      ENDIF
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION c_01
      c_01 = 0.0
C
*     FUNCTION c_21
      c_21 = k21*c
C
*     FUNCTION c_32
      c_32 = k32*c
C
*     FUNCTION c_30
      c_30 = 0.0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. space 
C     variable first at left borders of all areas, then 
C     at right borders of all areas:
C
*     FUNCTION cx_12
      cx_12 = D2/D1*c_x
C
*     FUNCTION cx_23
      cx_23 = D3/D2*c_x
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      fit = y1/V
C
*     FUNCTION bang_bang
      bang_bang = Vm
C
C------------------------------------------------------
C
C   - Constraints:
C
*     FUNCTION g(j), j IN ind_res
      g(j) = tbreak(j+1) - tbreak(j) - eps
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
