C
C------------------------------------------------------
C
C     Problem:    JFIT
C
C     Date:       19.5.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      gaskon = 8.13
      gamma_0 = 7.24E+01
      temp = 2.96E+02
      gamma_inf = 4.36E+01
      c_0 = 0.8
      p_3 = gaskon*temp*gamma_inf
      p_4 = gamma_0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k_11, k_12, k_21, k_22, h, Y0, t0, Y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION  YP
      if (t.lt.t0) then
        p_1 = k_11*c_0
        p_2 = k_12   
      else
        p_1 = k_21*c_0
        p_2 = k_22   
      endif
      YP = p_1*(1 - Y)*dexp(h*Y**2) - p_2*Y*dexp(h*(1 - Y)**2)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y_0
      if (t.lt.t0) then
        Y_0 = Y0
      else
        Y_0 = Y
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT
      FIT = p_4 + p_3*dlog(1 - Y)
C
*     FUNCTION PLOT
      PLOT = Y
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


