C
C------------------------------------------------------
C
C     Problem:    ISO_2PHA
C
C     Date:       31.01.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      F = 0.15
      V = 0.01
      cAf = 1
      cBf = 1
      cCf = 5
      cDf = 2
C
C------------------------------------------------------
C
*     SPLINE jA
      0.0   0.0
      0.1  -0.05
      0.3  -0.015
      0.4   0.0
      0.45  0.01
      0.5   0.01
      0.6   0.01
      1.0   0.01
C
*     SPLINE jB
      0.0   0.0
      0.1   0.025
      0.3   0.015
      0.4   0.01
      0.5   0.005
      0.6   0.0
      1.0   0.0
C
*     SPLINE jC
      0.0   0.0
      0.1   0.005
      0.3   0.005
      0.4   0.002
      0.5   0.004
      0.6   0.005
      1.0   0.005
C
*     SPLINE jD
      0.0   0.0
      0.1   0.005
      0.3  -0.01
      0.4  -0.02
      0.5  -0.005
      0.6   0.005
      1.0   0.005
C
C------------------------------------------------------
C

C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, cA, cB, cC, cD, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION cA_t
      cA_t = F/V*(cAf - cA) - k1*cA - 2*k3*abs(cA)**2 - jA(t)/V
C
*     FUNCTION cB_t
      cB_t = F/V*(cBf - cB) + k1*cA - k2*cB - jB(t)/V
C
*     FUNCTION cC_t
      cC_t = F/V*(cCf - cC) + k2*cC - jC(t)/V
C
*     FUNCTION cD_t
      cD_t = F/V*(cDf - cD) + k3*abs(cA)**2 - jD(t)/V
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION cA_0
      cA_0 = 10
C
*     FUNCTION cB_0
      cB_0 = 0
C
*     FUNCTION cC_0
      cC_0 = 0
C
*     FUNCTION cD_0
      cD_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION cA_fit
      cA_fit = cA
C
*     FUNCTION cB_fit
      cB_fit = cB
C
*     FUNCTION cC_fit
      cC_fit = cC
C
*     FUNCTION cD_fit
      cD_fit = cD
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

