C
C------------------------------------------------------
C
C     Problem:    ISOTOP1
C
C     Date:       04.06.99
C
C------------------------------------------------------
C
*     REAL CONSTANT
      f81 = 0.042
      f83 = 0.042
      f84 = 0.042
      f85 = 0.042
      f86 = 0.042
      f87 = 0.042
      f19 = 0.044
      f29 = 0.044
      f39 = 0.044
      f49 = 0.044
      f59 = 0.044
      f69 = 0.044
      f79 = 0.044
      y10 = 0.04810
      y30 = 0.39771
      y40 = 0.02446
      y50 = 0.12291
      y60 = 0.02278
      y70 = 0.49964
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      r1,f1p
      f12, f23, f24, f32, f43
      f52, f72, f73, f74
      y20, y80, y90 , f31
      y1, y2, y3, y4, y5, y6, y7, y8, y9, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -(f19 + f12)*y1 + f81*y8 + f31*y3 + r1 - f1p*y1
C
*     FUNCTION y2_t
      y2_t = -(f24 + f29 + f23)*y2 + f72*y7 + f52*y5 + f32*y3
     /       + f12*y1
C
*     FUNCTION y3_t
      y3_t = -(f31 + f32 + f39)*y3 + f83*y8 + f73*y7 + f23*y2 
     /      + f43*y4
C
*     FUNCTION y4_t
      y4_t = -(f43 + f49)*y4 + f24*y2 + f74*y7 + f84*y8
C
*     FUNCTION y5_t
      y5_t = -(f52 + f59)*y5 + f85*y8
C
*     FUNCTION y6_t
      y6_t = -f69*y6 + f86*y8
C
*     FUNCTION y7_t
      y7_t = -(f72 + f74 + f79 + f73)*y7 + f87*y8
C
*     FUNCTION y8_t
      y8_t = -(f81 + f86 + f87 + f83 + f84 + f85)*y8 
C
*     FUNCTION y9_t
      y9_t = f49*y4 + f29*y2 + f69*y6 + f59*y5 + f79*y7
     /        + f19*y1 + f39*y3
C
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = y10
C
*     FUNCTION y2_0
      y2_0 = y20
C
*     FUNCTION y3_0
      y3_0 = y30
C
*     FUNCTION y4_0
      y4_0 = y40
C
*     FUNCTION y5_0
      y5_0 = y50
C
*     FUNCTION y6_0
      y6_0 = y60
C
*     FUNCTION y7_0
      y7_0 = y70
C
*     FUNCTION y8_0
      y8_0 = y80
C
*     FUNCTION y9_0
      y9_0 = y90
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y4_fit = y4
C
*     FUNCTION y5_fit
      y5_fit = y5
C
*     FUNCTION y6_fit
      y6_fit = y6
C
*     FUNCTION y7_fit
      y7_fit = y7
C
*     FUNCTION y8_fit
      y8_fit = y8
C
*     FUNCTION y9_fit
      y9_fit = y9
C    
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C








