C
C------------------------------------------------------
C
C     Problem:    ISOTHRM2
C
C     Date:       21.11.1996
C
C------------------------------------------------------
C
*     PARAMETER
      n  = 4
C
C------------------------------------------------------
C
*     SET OF INDICES
      aind  = 1..n
      test  = 1..9
C
C------------------------------------------------------
C
*     REAL CONSTANT
      D = 0.1
      q = 1
      u1 = 0.2
      u2 = 0.4
      u3 = 0.6
      u4 = 0.8
      h  = 0.2
C
C------------------------------------------------------
C
*     LININT f
      0.0  1.0
      1.0  0.5
      2.0  0.1
      3.0  0.0
      10.0 0.0 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      a(j), j in aind
      u, u_x, u_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      phi = 0
      IF (u.GT.0) THEN
        if (u.lt.u1) then
          phi = a(1)*u/h
        else
        if (u.lt.u2) then
          phi = (a(2)-a(1))*(u-u1)/h + a(1)
        else
        if (u.lt.u3) then
          phi = (a(3)-a(2))*(u-u2)/h + a(2)
        else
        if (u.lt.u4) then
          phi = (a(4)-a(3))*(u-u3)/h + a(3)
        else
          phi = a(4)
        endif
        endif
        endif
        endif
      endif
      u_t = (D*u_xx - q*u_x)/(phi + 1)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION ul_x
      ul_x = q*(u -f(t))/D
C
*     FUNCTION ur_x
      ur_x = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT
      FIT = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = a(2) - a(1)
C
*     FUNCTION g2
      g2 = a(3) - a(2)
C
*     FUNCTION g3
      g3 = a(4) - a(3)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

