C
C------------------------------------------------------
C
C     Problem:    ISOTHRM1
C
C     Date:       21.11.1996
C
C------------------------------------------------------
C
*     PARAMETER
      n  = 10
C
C------------------------------------------------------
C
*     SET OF INDICES
      aind  = 1..n
C
C------------------------------------------------------
C
*     REAL CONSTANT
      D = 0.1
      q = 1
      u1 = 0.1
      u2 = 0.2
      u3 = 0.3
      u4 = 0.4
      u5 = 0.5
      u6 = 0.6
      u7 = 0.7
      u8 = 0.8
      u9 = 0.9
      u10 = 1.0
      h = 0.1
      k = 50
C
C------------------------------------------------------
C
*     LININT f
      0.0  1.0
      1.0  0.5
      2.0  0.1
      3.0  0.0
      10.0 0.0 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      a(j), j in aind
      u, s, u_x, s_x, u_xx, s_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      phi = 0
      IF (u.GT.0) THEN
        if (u.lt.u1) then
          phi = a(1)*u/h
        else
        if (u.lt.u2) then
          phi = (a(2)-a(1))*(u-u1)/h + a(1)   
        else
        if (u.lt.u3) then
          phi = (a(3)-a(2))*(u-u2)/h + a(2)
        else
        if (u.lt.u4) then
          phi = (a(4)-a(3))*(u-u3)/h + a(3)
        else
        if (u.lt.u5) then
          phi = (a(5)-a(4))*(u-u4)/h + a(4)
        else
        if (u.lt.u6) then
          phi = (a(6)-a(5))*(u-u5)/h + a(5)
        else
        if (u.lt.u7) then
          phi = (a(7)-a(6))*(u-u6)/h + a(6)
        else
        if (u.lt.u8) then
          phi = (a(8)-a(7))*(u-u7)/h + a(7)
        else
        if (u.lt.u9) then
          phi = (a(9)-a(8))*(u-u8)/h + a(8)
        else
          phi = (a(10)-a(9))*(u-u9)/h + a(9)
        endif
        endif
        endif
        endif
        endif
        endif
        endif
        endif
        endif
      endif
      u_t = D*u_xx - q*u_x - k*(phi - s)
C
*     FUNCTION s_t
      s_t = k*(phi - s) 
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = 0
C
*     FUNCTION s_0
      s_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION ul_x
      ul_x = q*(u -f(t))/D    
C
*     FUNCTION ur_x
      ur_x = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT
      FIT = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = a(2) - a(1)
C
*     FUNCTION g2
      g2 = a(3) - a(2)
C
*     FUNCTION g3
      g3 = a(4) - a(3)
C
*     FUNCTION g4
      g4 = a(5) - a(4)
C
*     FUNCTION g5
      g5 = a(6) - a(5)
C
*     FUNCTION g6
      g6 = a(7) - a(6)
C
*     FUNCTION g7
      g7 = a(8) - a(7)
C
*     FUNCTION g8
      g8 = a(9) - a(8)
C
*     FUNCTION g9
      g9 = a(10) - a(9)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


