C
C------------------------------------------------------
C
C     Problem:  ISOMER_X
C
C     Date:     18.11.94
C
C------------------------------------------------------
C
*     REAL CONSTANT
      y10 = 100.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      theta1, theta2, theta3, theta4, theta5, t
C
C------------------------------------------------------
C
C   - Fitting criteria:
C   
*     FUNCTION y1
      phi = theta1 + theta2
      y1 = y10*EXP(-phi*t)
C
*     FUNCTION y2
      y2 = theta1*y10/phi*(1 - EXP(-phi*t))
C
*     FUNCTION y3
      alpha = theta3 + theta4 + theta5
      beta = 0.5*(-alpha + SQRT(alpha**2-4*theta3*theta5))
      gamma = 0.5*(-alpha - SQRT(alpha**2-4*theta3*theta5))
      c1 = theta2*y10*(theta5-phi)/((phi+beta)*(phi+gamma))
      c2 = theta2*y10*(theta5+beta)/((phi+beta)*(beta-gamma))
      c3 = theta2*y10*(theta5+gamma)/((phi+gamma)*(gamma-beta))
      y3 = c1*EXP(-phi*t) + c2*EXP(beta*t) + c3*EXP(gamma*t)
C
*     FUNCTION y4
      y4 = theta3*(c1/phi*(1 - EXP(-phi*t)) +
     /     c2/beta*(EXP(beta*t)-1) + c3/gamma*(EXP(gamma*t)-1))
C
*     FUNCTION y5
      y5 = theta4*(c1/(theta5-phi)*EXP(-phi*t) 
     /     + c2/(theta5+beta)*EXP(beta*t)
     /     + c3/(theta5+gamma)*EXP(gamma*t))
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

