C
C------------------------------------------------------
C
C     Problem:    ISOMER
C
C     Date:       21.6.1999
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A1, A2, A3, A4, A5, Y1, Y2, Y3, Y4, Y5, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P=-(A1 + A2)*Y1
C
*     FUNCTION Y2P
      Y2P=A1*Y1
C
*     FUNCTION Y3P
      Y3P=A2*Y1 - (A3 + A4)*Y3 + A5*Y5
C
*     FUNCTION Y4P
      Y4P=A3*Y3
C
*     FUNCTION Y5P
      Y5P=A4*Y3 - A5*Y5
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10=100
C
*     FUNCTION Y20
      Y20=0
C
*     FUNCTION Y30
      Y30=0
C
*     FUNCTION Y40
      Y40=0
C
*     FUNCTION Y50
      Y50=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT=Y1
C
*     FUNCTION Y2FIT
      Y2FIT=Y2
C
*     FUNCTION Y3FIT
      Y3FIT=Y3
C
*     FUNCTION Y4FIT
      Y4FIT=Y4
C
*     FUNCTION Y5FIT
      Y5FIT=Y5
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



