C
C------------------------------------------------------
C
C     Problem:    IRB6400
C
C     Date:       30.05.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      G = 9.81
      L11 =  0.188d0
      L13 =  0.900d0
      S11 =  0.130d0
      S13 =  0.783d0
      M1  =  510.0d0
      I1Z   =   28.0d0                   
      L23 =  0.950d0
      S21 = -0.010d0
      S22 =  0.007d0
      S23 =  0.430d0
      M2  =  240.0d0
      I2X  =   33.63d0
      I2Y  =   28.43d0
      I2Z  =   9.4d0
      WERKZEUG = 0.d0
      S31 =  0.5491d0 
      S32 = -0.0233d0
      S33 = 0.225d0 - 0.0079d0 
      M3  =  294.9d0 + WERKZEUG
      I3X   =  8.6107d0
      I3Y   =  181.8004d0
      I3Z   =  195.2742d0        
      SGW1 = -0.665d0
      SGW3 = -0.015d0
      MGW    =  465.0d0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      u11, u12, u13, u21, u22, u23, u31, u32, u33
      x1, x2, x3, x4, x5, x6, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t=x4
C
*     FUNCTION x2_t
      x2_t=x5
C
*     FUNCTION x3_t
      x3_t=x6
C
*     FUNCTION x4_t
      if (t.lt.0.2) then
        u1=u11
      else
        if (t.lt.1.7) then
          u1=u12
        else
          u1=u13
        endif
      endif
      if (t.lt.0.2) then
        u2=u21
      else
        if (t.lt.1.7) then
          u2=u22
        else
          u2=u23
        endif
      endif
      if (t.lt.0.2) then
        u3=u31
        else
        if (t.lt.1.7) then
          u3=u32
        else
          u3=u33
        endif
      endif
c
      umax1 = 16.d0 *36.77d0 * 14.5d0 * 0.4d0
      umax2 = 13.d0 *36.77d0 * 14.5d0 * 0.5d0
      umax3 = 13.d0 *36.77d0 * 14.5d0 * 0.5d0
      UR1 = -380.d0 * TANH (3.d0*x1)
      UR2 = -345.d0 * TANH (3.d0*x2)
      UH     = -3783.4297d0*x5
      UR3 = -337.d0 * TANH (3.d0*x3)       
      t1 = s11*s11
      t3 = s23*s23
      t4 = dcos(x5)
      t5 = t4*t4
      t7 = s21*s21
      t9 = l11*l11
      t10 = t4*s21
      t13 = dsin(x5)
      t14 = t13*s23
      t17 = s22*s22
      t22 = t13*t13
      t25 = dsin(x6)
      t26 = t25*s33
      t29 = dcos(x6)
      t30 = t29*s31
      t33 = l23*l23
      t35 = t29*t29
      t36 = s31*s31
      t38 = s33*s33
      t40 = s32*s32
      t43 = t13*l23
      t46 = t30*t43
      t48 = t26*t43
      t50 = 2.D0*t26*l11+2.D0*t30*l11-t33*t5+t33+t35*t36+t9-t38*t35+
     #t40+2.D0*t30*t26+2.D0*t43*l11+t38+2.D0*t46+2.D0*t48
      t52 = t25*t25
      t55 = sgw1*sgw1
      t57 = sgw3*sgw3
      t58 = t29*sgw1
      t61 = t25*sgw3
      t77 = t4*l23
      t79 = m2*(s22*t13*s21-s22*t4*s23)-m3*s32*t77
      t85 = m3*(s32*t25*s31-s32*t29*s33)
      t95 = m3*(t46+t48+t77*t29*s33-t77*t25*s31)
      MM11 = m1*t1+i1z+m2*(-t3*t5+t5*t7+t9+t3+2.D0*t10*l11+2.D0
     #*t14*l11+t17+2.D0*t10*t14)+i2x*t22+i2z*t5+m3*t50+i3x*t52+i3z
     #*t35+mgw*(t9+t35*t55+t57+2.D0*t58*l11+2.D0*t61*l11-t57*t35
     #+2.D0*t58*t61)
      MM12 = t79
      MM13 = t85
      MM21 = t79
      MM22 = m2*(t3+t7)+i2y+m3*t33
      MM23 = t95
      MM31 = t85
      MM32 = t95
      MM33 = m3*(t36+t38)+i3y+mgw*(t57+t55)
      t1 = m3*l23
      t2 = dsin(x5)
      t4 = x2*x2
      t7 = x2*m2
      t8 = t7*x1
      t10 = 2.D0*x5
      t11 = dcos(t10)
      t12 = s21*s23*t11
      t15 = x3*m3
      t16 = t15*l23
      t17 = x1*s31
      t18 = x6+x5
      t19 = dcos(t18)
      t20 = t17*t19
      t22 = m2*s22
      t23 = dcos(x5)
      t27 = x3*mgw
      t28 = sgw1*sgw1
      t30 = 2.D0*x6
      t31 = dsin(t30)
      t34 = t15*x1
      t35 = dsin(x6)
      t37 = t35*s31*l11
      t40 = s23*s23
      t42 = dsin(t10)
      t45 = s31*s31
      t50 = x1*t42
      t55 = x1*t31
      t59 = x2*m3
      t60 = l23*l23
      t65 = t23*s23*l11
      t68 = t27*x1
      t70 = t35*sgw1*l11
      t73 = dcos(x6)
      t75 = t73*s33*l11
      t78 = m3*s32
      t79 = x3*x3
      t83 = -t1*s32*t2*t4-2.D0*t8*t12-t16*t20-t22*t4*t23*s21+t27*x1
     #*t28*t31+2.D0*t34*t37-t7*x1*t40*t42+t15*x1*t45*t31-x2*i2x*t50
     #+x2*i2z*t50-x3*i3x*t55+x3*i3z*t55-t59*t60*x1*t42-2.D0*t8
     #*t65+2.D0*t68*t70-2.D0*t34*t75-t78*t79*t35*s33
      t87 = s33*s33
      t92 = dcos(t30)
      t93 = s31*s33*t92
      t96 = sgw3*sgw3
      t101 = sgw1*sgw3*t92
      t104 = t59*l23
      t105 = x1*s33
      t106 = dsin(t18)
      t107 = t105*t106
      t109 = -x6+x5
      t110 = dcos(t109)
      t111 = t17*t110
      t113 = s21*s21
      t118 = dsin(t109)
      t119 = t105*t118
      t126 = t2*s21*l11
      t136 = t73*sgw3*l11
      t139 = -t78*t79*t73*s31-t15*x1*t87*t31-2.D0*t34*t93-t27*x1*t96
     #*t31-2.D0*t68*t101-t104*t107+t16*t111+t7*x1*t113*t42-t104*t20-
     #t16*t119-t22*t4*t2*s23-t16*t107+2.D0*t8*t126-t104*t111-2.D0*t104
     #*x1*t23*l11+t104*t119-2.D0*t68*t136
      t141 = x1*x1
      t148 = m2*t141
      t161 = t141*s31
      t164 = t1*t161*t110/2.D0
      t167 = t1*t161*t19/2.D0
      t168 = t141*s33
      t171 = t1*t168*t106/2.D0
      t174 = t1*t168*t118/2.D0
      t185 = g*m2
      t190 = g*m3
      t193 = i2x*t141*t42/2.D0-i2z*t141*t42/2.D0-t148*t126+t148*t65
     #+t148*t12+t148*t40*t42/2.D0-t148*t113*t42/2.D0+t1*t141*t23*l11
     #+t164+t167+t171-t174+m3*t60*t141*t42/2.D0-t1*t79*s33*t118+t1
     #*t79*s31*t110+t185*t23*s21+t185*t2*s23+t190*t2*l23
      t200 = m3*t141
      t210 = i3x*t141*t31/2.D0-t164+t167+t171+t174-i3z*t141*t31/2.D0
     #+t200*t93+t200*t75-t200*t37+t200*t87*t31/2.D0-t200*t45*t31/2.D0
      t215 = g*mgw
      t220 = mgw*t141
      t236 = t190*t73*s31+t190*t35*s33+t215*t73*sgw1+t215*t35*sgw3
     #-t220*t70+t220*t136+t220*t101-t220*t28*t31/2.D0+t220*t96*t31/2.D0
     #-t1*t4*s31*t110+t1*t4*s33*t118
      rs1 = t83+t139
      rs2 = t193
      rs3 = t210+t236
      RS1 = RS1 + U1*umax1 + UR1
      RS2 = RS2 + U2*umax2 + UR2 + UH
      RS3 = RS3 + U3*umax3 + UR3
      MMDET = MM11*MM22*MM33 - MM11*MM23*MM32 -
     #     MM12*MM21*MM33 + 2.d0*MM12*MM13*MM23-
     #     MM31*MM13*MM22
      MMI11 = (MM22*MM33-MM23*MM32)/MMDET
      MMI12 = (MM12*MM33-MM13*MM23)/MMDET
      MMI13 = (MM13*MM22-MM12*MM23)/MMDET
      MMI21 = MMI12
      MMI22 = (MM11*MM33-MM13*MM31)/MMDET
      MMI23 = (MM12*MM13-MM11*MM23)/MMDET
      MMI31 = MMI13
      MMI32 = MMI23
      MMI33 = (MM11*MM22-MM12*MM21)/MMDET
      func1 = MMI11*RS1+MMI12*RS2+MMI13*RS3
      func2 = MMI21*RS1+MMI22*RS2+MMI23*RS3
      func3 = MMI31*RS1+MMI32*RS2+MMI33*RS3
C
      x4_t=func1
C
*     FUNCTION x5_t
      x5_t=func2
C
*     FUNCTION x6_t
      x6_t=func3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.001) then
        x1_0 = 1.6
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.001) then
        x2_0 = 0
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.lt.0.001) then
        x3_0 = 0
      else
        x3_0 = x3
      endif
C
*     FUNCTION x4_0
      if (t.lt.0.001) then
        x4_0 = 0
      else
        x4_0 = x4
      endif
C
*     FUNCTION x5_0
      if (t.lt.0.001) then
        x5_0 = 0
      else
        x5_0 = x5
      endif
C
*     FUNCTION x6_0
      if (t.lt.0.001) then
        x6_0 = 0
      else
        x6_0 = x6
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION x5_fit
      x5_fit = x5
C
*     FUNCTION x6_fit
      x6_fit = x6
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



