C
C------------------------------------------------------
C
C     Problem:    IONTRAN3
C
C     Date:       23.09.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      rho = 1.9
      theta = 0.2473
      C0 = 1
      V = 600
      Ae = 3.14
      scale = 2.0E+4
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      D, KL, beta, c, c_x, c_xx, q, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_t
      if (c.gt.0) then
        c_t = D*c_xx/(1 + rho/theta*KL*c/(1+KL/beta*c)**2)
      else
        c_t = D*c_xx
      endif
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_0
      c_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of
C     coupled ordinary differential equations:
C
*     FUNCTION q_t
      q_t = -Ae*D/V*c_x
c
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0:
C
*     FUNCTION q_0
      q_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all
C     areas:
C
*     FUNCTION c_left
      c_left = C0
C
*     FUNCTION c_right
      c_right = q*V/Ae
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT
      FIT = q*scale
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
 