C
C------------------------------------------------------
C
C     Problem:    IONTRAN1
C
C     Date:       18.09.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      A = 3.14
      VD = 6
      VA = 6
      c0 = 0
      cD0 = 3
      cA0 = 0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      S, D
      c, c_x, c_xx, cD, cA, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_t
      c_t = D*c_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_0
      c_0 = c0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION cD_t
      K1 = S*A/VD
      cD_t = K1*D*c_x
C
*     FUNCTION cA_t
      K2 = S*A/VA
      cA_t = -K2*D*c_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION cD_0
      cD_0 = cD0
C
*     FUNCTION cA_0
      cA_0 = cA0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an 
C     area, etc.:
C
*     FUNCTION c_left
      c_left = S*cD
C
*     FUNCTION c_right
      c_right = S*cA
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit_1
      fit_1 = cD
C
*     FUNCTION fit_2
      fit_2 = cA
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
