C
C------------------------------------------------------
C
C     Problem:    IN_LAYER
C
C     Date:       10.06.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Delta = 0.1
      area = 1E8
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      kD1, kD2, kA2, kS2
      c, theta, c_z, theta_z, c_zz, theta_zz
      z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c1_t
      c1_t = kD1*c_zz
C
*     FUNCTION theta1_t
      theta1_t = 0
C
*     FUNCTION c2_t
      c2_t = kD2*c_zz - kA2*c + kS2*theta
C
*     FUNCTION theta2_t
      theta2_t = kA2*c - kS2*theta
C
*     FUNCTION c3_t
      c3_t = kD1*c_zz
C
*     FUNCTION theta3_t
      theta3_t = 0
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c1_0
      c1_0 = Delta
C
*     FUNCTION theta1_0
      theta1_0 = 0
C
*     FUNCTION c2_0
      c2_0 = Delta
C
*     FUNCTION theta2_0
      theta2_0 = 0
C
*     FUNCTION c3_0
      c3_0 = Delta
C
*     FUNCTION theta3_0
      theta3_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an 
C     area, etc.:
C
*     FUNCTION c12
      c12 = c
C
*     FUNCTION c23
      c23 = c
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. space 
C     variable first at left borders of all areas, then 
C     at right borders of all areas:
C
*     FUNCTION c12_z 
      c12_z = kD2/kD1*c_z
C
*     FUNCTION c23_z 
      c23_z = kD1/kD2*c_z
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION F1
      F1 = -area*kD1*c_z
C
*     FUNCTION F2
      F2 = -area*kD1*c_z
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

