C
C------------------------------------------------------
C
C     Problem:    INV_PROB
C
C     Date:       09.03.2002
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..10
      ind1 = 1..100
      ind2 = 1..9
C
C------------------------------------------------------
C
*     INDEX
      i
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      p(j), j in ind
      u, u_x, u_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION u_t
      u_t = u_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION u_0
      if (t.lt.0.001) then
        u_0 = 0
      else
        u_0 = u
      endif
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_left
c      u_left = t - 1/6 
c     /    - 2/pi**2*sum(exp(-k**2*pi**2*t)*cos(k*pi)/k**2, k in ind1)
C
*     FUNCTION u_right
      u_right = 0
      i = 1
 1000 continue
      if (t.lt.0.1*i) then
        u_right = p(i)
        goto 2000
      endif
      i = i+1
      if (i.le.10) then
        goto 1000
      endif
 2000 continue
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION u_x_left
      u_x_left = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      fit = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g(j), j in ind2
      g(j) = p(j+1) - p(j)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

