C
C------------------------------------------------------
C
C     Problem:    INTERLEU
C
C     Date:       02.10.2001
C
C------------------------------------------------------
C
*     REAL DATA
      L01 = 15
      L02 = 70
      L03 = 200
      L04 = 500
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      R0, C0, b, k1, km1, k2, km2, k3, k4, km4
      B05, G05, B06, G06, B07, G07
      B1, G1, H1, X1
      B2, G2, H2, X2
      B3, G3, H3, X3
      B4, G4, H4, X4
      B5, G5, H5, X5
      B6, G6, H6, X6
      B7, G7, H7, X7
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION B1_t
      L1 = L01 - B1 - G1 - X1
      if (L1.lt.0) then
        pLb1 = 0
      else 
        pLb1 = L1**(1+b)
      endif
      B1_t = k1*pLb1*(R0-B1-G1) - km1*B1 - k2*B1*(C0-G1) + km2*G1  
C
*     FUNCTION G1_t
      G1_t = k2*B1*(C0-G1) - km2*G1 
C
*     FUNCTION H1_t
      H1_t = k3*G1 - k4*L1*H1 + km4*X1 
C
*     FUNCTION X1_t
      X1_t = k4*L1*H1 - km4*X1  
C
C
*     FUNCTION B2_t
      L2 = L02 - B2 - G2 - X2
      if (L2.lt.0) then
        pLb2 = 0
      else 
        pLb2 = L2**(1+b)
      endif
      B2_t = k1*pLb2*(R0-B2-G2) - km1*B2 - k2*B2*(C0-G2) + km2*G2  
C
*     FUNCTION G2_t
      G2_t = k2*B2*(C0-G2) - km2*G2 
C
*     FUNCTION H2_t
      H2_t = k3*G2 - k4*L2*H2 + km4*X2 
C
*     FUNCTION X2_t
      X2_t = k4*L2*H2 - km4*X2  
C
C
*     FUNCTION B3_t
      L3 = L03 - B3 - G3 - X3
      if (L3.lt.0) then
        pLb3 = 0
      else 
        pLb3 = L3**(1+b)
      endif
      B3_t = k1*pLb3*(R0-B3-G3) - km1*B3 - k2*B3*(C0-G3) + km2*G3  
C
*     FUNCTION G3_t
      G3_t = k2*B3*(C0-G3) - km2*G3 
C
*     FUNCTION H3_t
      H3_t = k3*G3 - k4*L3*H3 + km4*X3 
C
*     FUNCTION X3_t
      X3_t = k4*L3*H3 - km4*X3  
C
C
*     FUNCTION B4_t
      L4 = L04 - B4 - G4 - X4
      if (L4.lt.0) then
        pLb4 = 0
      else 
        pLb4 = L4**(1+b)
      endif
      B4_t = k1*pLb4*(R0-B4-G4) - km1*B4 - k2*B4*(C0-G4) + km2*G4  
C
*     FUNCTION G4_t
      G4_t = k2*B4*(C0-G4) - km2*G4 
C
*     FUNCTION H4_t
      H4_t = k3*G4 - k4*L4*H4 + km4*X4 
C
*     FUNCTION X4_t
      X4_t = k4*L4*H4 - km4*X4  
C
C
*     FUNCTION B5_t
      B5_t = -km1*B5 - k2*B5*(C0-G5) + km2*G5 
C
*     FUNCTION G5_t
      G5_t = k2*B5*(C0-G5) -km2*G5
C
*     FUNCTION H5_t
      H5_t = 0
C
*     FUNCTION X5_t
      X5_t = 0
C
C
*     FUNCTION B6_t
      B6_t = -km1*B6 - k2*B6*(C0-G6) + km2*G6 
C
*     FUNCTION G6_t
      G6_t = k2*B6*(C0-G6) -km2*G6
C
*     FUNCTION H6_t
      H6_t = 0
C
*     FUNCTION X6_t
      X6_t = 0
C
C
*     FUNCTION B7_t
      B7_t = -km1*B7 - k2*B7*(C0-G7) + km2*G7 
C
*     FUNCTION G7_t
      G7_t = k2*B7*(C0-G7) -km2*G7
C
*     FUNCTION H7_t
      H7_t = 0
C
*     FUNCTION X7_t
      X7_t = 0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION B1_0
      B1_0 = 0
C
*     FUNCTION G1_0
      G1_0 = 0
C
*     FUNCTION H1_0
      H1_0 = 0
C
*     FUNCTION X1_0
      X1_0 = 0
C
C
*     FUNCTION B2_0
      B2_0 = 0
C
*     FUNCTION G2_0
      G2_0 = 0
C
*     FUNCTION H2_0
      H2_0 = 0
C
*     FUNCTION X2_0
      X2_0 = 0
C
C
*     FUNCTION B3_0
      B3_0 = 0
C
*     FUNCTION G3_0
      G3_0 = 0
C
*     FUNCTION H3_0
      H3_0 = 0
C
*     FUNCTION X3_0
      X3_0 = 0
C
C
*     FUNCTION B4_0
      B4_0 = 0
C
*     FUNCTION G4_0
      G4_0 = 0
C
*     FUNCTION H4_0
      H4_0 = 0
C
*     FUNCTION X4_0
      X4_0 = 0
C
C
*     FUNCTION B5_0
      B5_0 = B05
C
*     FUNCTION G5_0
      G5_0 = G05
C
*     FUNCTION H5_0
      H5_0 = 0
C
*     FUNCTION X5_0
      X5_0 = 0
C
C
*     FUNCTION B6_0
      B6_0 = B06
C
*     FUNCTION G6_0
      G6_0 = G06
C
*     FUNCTION H6_0
      H6_0 = 0
C
*     FUNCTION X6_0
      X6_0 = 0
C
C
*     FUNCTION B7_0
      B7_0 = B07
C
*     FUNCTION G7_0
      G7_0 = G07
C
*     FUNCTION H7_0
      H7_0 = 0
C
*     FUNCTION X7_0
      X7_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION A1_fit
      A1_fit = B1 + G1
C
*     FUNCTION A2_fit
      A2_fit = B2 + G2
C
*     FUNCTION A3_fit
      A3_fit = B3 + G3 
C
*     FUNCTION A4_fit
      A4_fit = B4 + G4 
C
*     FUNCTION A5_fit
      A5_fit = B5 + G5 
C
*     FUNCTION A6_fit
      A6_fit = B6 + G6 
C
*     FUNCTION A7_fit
      A7_fit = B7 + G7 
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
