C
C------------------------------------------------------
C
C     Problem:    INTERF1
C
C     Date:       31.01.1996
C
C------------------------------------------------------
C
*     SET OF INDICES
      IND = 1..10
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      A, B, U, UX, UXX, X, T
C
*     FUNCTION UP
      IF (X.LE.0.5) THEN
         IF (X.GT.0) THEN
           UP = A*(2/X*UX + UXX) - B*EXP(U)
         ELSE
           UP = A*UXX - B*EXP(U)
         ENDIF 
      ELSE
         UP = (2/X*UX + UXX) - EXP(U)
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION U0
      IF (X.LT.1) THEN
         U0 = 0.0
      ELSE
         U0 = 1.0
      ENDIF
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION UR
      UR = 1.0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION UXL
      UXL = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION FIT(I), I IN IND
      FIT(I) = U
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
