C
C------------------------------------------------------
C
C     Problem:    INHIB
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      UM=1
      KS=0.1
      KI=2
      YSX=0.5
      KO=0.1
      YOS=150
      KLA=50
      M=0.0266
      VL=100
      G=6000
      EPS=0.15
      KP=10
      S2SET=5.0  
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      CL1, CG1, S1, X, S2, CL2, CG2, F0, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      VG=EPS*VL
      YO=CG2/1430  
      E=S2SET-S2
      F=F0+KP*E
      CLS=M*CG2
      U=UM*S2/(KS+S2+S2*S2/KI)*CL2/(KO+CL2)   
      RX=U*X  
      RS=-U*X/YSX 
      RO=RS*YOS
      OUR=-RO
      XP=-(F/VL)*X+RX 
C
*     FUNCTION S2P
      S2P=(F/VL)*(S1-S2)+RS   
C
*     FUNCTION CL2P
      CL2P=(F/VL)*(CL1-CL2)+RO+KLA*(CLS-CL2)  
C
*     FUNCTION CG2P
      CG2P=(G/VG)*(CG1-CG2)-KLA*(CLS-CL2)*(VL/VG) 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0=2
C
*     FUNCTION S2_0
      S2_0=0
C
*     FUNCTION CL2_0
      CL2_0=8
C
*     FUNCTION CG2_0
      CG2_0=300
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit=X
C
*     FUNCTION S2_fit
      S2_fit=S2
C
*     FUNCTION CL2_fit
      CL2_fit=CL2
C
*     FUNCTION CG2_fit
      CG2_fit=CG2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
