C
C------------------------------------------------------
C
C     Problem:    INC_STIFF
C
C     Date:       16.7.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      b = 1000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, c, y1, y2, n, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -(b + a*n)*y1 + b*y2**n
C
*     FUNCTION y2_t
      y2_t = y1 - a*y2 - y2**n
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = c**n
C
*     FUNCTION y2_0
      y2_0 = c
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

