C
C------------------------------------------------------
C
C     Problem:    IDENT2
C
C     Date:       26.3.1999
C
C------------------------------------------------------
C
*     LININT u
      0.0    0.1
      1.0    0.2
      2.0    0.7
      2.5    0.4
      3.0    0.56
      8.0    0.7
      100.0  0.2
C
C------------------------------------------------------
C
*     MACRO k1
      k1 = p1*exp(p2*u(t))
C
*     MACRO k2
      k2 = p3*exp(p4*u(t))
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      p1, p2, p3, p4, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      x_t = k1*(100 - x) - k2*x
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = k1/(k1 + k2)
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      fit = k1*(1 - x) + k2*x
C
*     FUNCTION plot
      plot = x
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
