C
C------------------------------------------------------
C
C     Problem:    HYPER
C
C     Date:       14.03.99
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..9
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      p1, p2, u1, u2, u1_x, u2_x, u1_xx, u2_xx, 
     /      f1, f2, f1_x, f2_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION flux1
      flux1 = p1*u1 - (p1+p2)*u2
C
*     FUNCTION flux2
      flux2 = p2*u2 
C
*     FUNCTION u1_t
      u1_t = f1_x 
C
*     FUNCTION u2_t
      u2_t = f2_x 
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_0
      u1_0 = 0.0
C
*     FUNCTION u2_0
      u2_0 = 0.0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u1_left
      u1_left = 1
C
*     FUNCTION u2_right
      u2_right = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind
      fit(i)= u1 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
