C
C------------------------------------------------------
C
C     Problem:    HYGROS
C
C     Date:       06.03.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      A = 0.00794
      L = 1.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      D, Ka, Kb, U, Ux, Uxx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION Up
      Up = D*Uxx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION U0
      U0 = 0.54E-4
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
c*     FUNCTION Ul
c      Ul = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION Uxl
      Uxl = -(Ka*A - Kb*U)/D 
C
*     FUNCTION Uxr
      Uxr = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Fit
      Fit = SIMPSN(1,1)/L
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
