C
C------------------------------------------------------
C
C     Problem:    HYDRO_3S
C
C     Date:       7.5.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      b1 = 5
      b2 = 5
      b3 = 5
      g = 9.81
      beta = 1
      c = 0.1
      w1 = 0.001
      w2 = 0.001
      w3 = 0.001
      Q0 = 1.65
      H0 = 1.2
      alpha = 0.1
      Hd2 = 0.5
      Hd3 = 0.5
      H1goal = 2.1
      H2goal = 1.9
      H3goal = 1.9
C
C------------------------------------------------------
C
*     LININT input
         0.0    1.65
        20.0    50.0
        80.0    1.65 
       500.0    0.0
C
C------------------------------------------------------
C
*     MACRO u2
      s = 0.001
      u2 = u21 + u22*(s*t) + u23*(s*t)**2 
C
*     MACRO u3
      s  =0.001
      u3 = u31 + u32*(s*t) + u33*(s*t)**2 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      u21, u22, u23, u31, u32, u33
      Q1, H1, Q2, H2, Q3, H3
      Q1_x, H1_x, Q2_x, H2_x, Q3_x, H3_x
      Q1_xx, H1_xx, Q2_xx, H2_xx, Q3_xx, H3_xx
      fQ1, fH1, fQ2, fH2, fQ3, fH3
      fQ1_x, fH1_x, fQ2_x, fH2_x, fQ3_x, fH3_x
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux_Q1
      if (H1.lt.1.0E-10) then
        term = 0
        S = 0
      else
        A = b1*H1
        R = A/(b1+2*H1)
        term = beta/b1*Q1**2/H1
      endif
      flux_Q1 = -g*b1*H1**2/2  - term 
C
*     FUNCTION flux_H1
      flux_H1 = -Q1/b1
C
*     FUNCTION flux_Q2
      if (H2.lt.1.0E-10) then
        term = 0
        S = 0
      else
        A = b2*H2
        R = A/(b2+2*H2)
        term = beta/b2*Q2**2/H2
      endif
      flux_Q2 = -g*b2*H2**2/2  - term
C
*     FUNCTION flux_H2
      flux_H2 = -Q2/b2
C
*     FUNCTION flux_Q3
      if (H3.lt.1.0E-10) then
        term = 0
        S = 0
      else
        A = b3*H3
        R = A/(b3+2*H3)
        term = beta/b3*Q3**2/H3
      endif
      flux_Q3 = -g*b3*H3**2/2  - term
C
*     FUNCTION flux_H3
      flux_H3 = -Q3/b3
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION Q1_t
      if (H1.lt.1.0E-10) then
        S = 0
      else
        A = b1*H1
        R = A/(b1+2*H1)
        S = c**2*abs(Q1)*Q1/(R**(4/3)*A**2) - w1
      endif
      Q1_t = -g*b1*H1*S + fQ1_x
C
*     FUNCTION H1_t
      H1_t = fH1_x
C
*     FUNCTION Q2_t
      if (H2.lt.1.0E-10) then
        S = 0
      else
        A = b2*H2
        R = A/(b2+2*H2)
        S = c**2*abs(Q2)*Q2/(R**(4/3)*A**2) - w2
      endif
      Q2_t = -g*b2*H2*S + fQ2_x
C
*     FUNCTION H2_t
      H2_t = fH2_x
C
*     FUNCTION Q3_t
      if (H3.lt.1.0E-10) then
        S = 0
      else
        A = b3*H3
        R = A/(b3+2*H3)
        S = c**2*abs(Q3)*Q3/(R**(4/3)*A**2) - w3
      endif
      Q3_t = -g*b3*H3*S + fQ3_x
C
*     FUNCTION H3_t
      H3_t = fH3_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION Q1_0
      Q1_0 = -Q0
C
*     FUNCTION H1_0
      H1_0 = H0      
C
*     FUNCTION Q2_0
      Q2_0 = Q0
C
*     FUNCTION H2_0
      H2_0 = H0      
C
*     FUNCTION Q3_0
      Q3_0 = Q0
C
*     FUNCTION H3_0
      H3_0 = H0      
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION equ1
c      equ1 = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION Q1_left
      Q1_left = -Q2 - Q3
C
*     FUNCTION Q2_left
      wq = (Q1**2/(2*H1**2) + g*H1 - g*H2)*2*H2**2
      if (wq.gt.0) then
        Q2_left = sqrt(wq)
      else
        Q2_left = 0
      endif
C
*     FUNCTION Q3_left
      wq = (Q1**2/(2*H1**2) + g*H1 - g*H3)*2*H3**2
      if (wq.gt.0) then
        Q3_left = sqrt(wq)
      else
        Q3_left = 0
      endif
C
*     FUNCTION Q1_right
      Q1_right = -input(t)
C
*     FUNCTION Q2_right
      if (H2-Hd2.gt.0) then
        Q2_right = alpha*u2*sqrt(g*(H2 - Hd2))
      else
        Q2_right = 0
      endif
C
*     FUNCTION Q3_right
      if (H3-Hd3.gt.0) then
        Q3_right = alpha*u3*sqrt(g*(H3 - Hd3))
      else
        Q3_right = 0
      endif
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit1
      fit1 = H1 - H1goal
C
*     FUNCTION fit2
      fit2 = H2 - H2goal 
C
*     FUNCTION fit3
      fit3 = H3 - H3goal
C
*     FUNCTION plot0
      plot0 = Q1 + Q2 + Q3
C
*     FUNCTION plot1
      plot1 = Q1
C
*     FUNCTION plot2
      plot2 = Q2
C
*     FUNCTION plot3
      plot3 = Q3
C
*     FUNCTION plot4
      plot4 = u2
C
*     FUNCTION plot5
      plot5 = u3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
