C
C------------------------------------------------------
C
C     Problem:    HYDROXY
C
C     Date:       06.07.2005
C
C------------------------------------------------------
C          
*     REAL CONSTANT
c      F  = 4
c      P0 = 1023
c      Kd = 0.1
C
C------------------------------------------------------
C          
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Ka, Wmax, F, Kd, P0, W, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION W_t
      W_t =  - F*W + Ka*(P0 - W)*(Wmax - W) - Kd*W
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION W_0
      W_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION W_fit
      W_fit = W
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
