C
C------------------------------------------------------
C
C     Problem:    HYDROL
C
C     Date:       23.01.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R = 1.987  
      R0 = 65.5  
      CP = 0.9   
      H = -90000 
      M = 500
      A0 = 1.35000E-02   
      TR0 = 600  
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Z, E, A, TR, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION AP
      K = Z*1E7*EXP(-E*1E4/(R*TR))
      AP = -K*A   
C
*     FUNCTION TRP
      V = M/R0
      TRP = (-K*A*V*H)/(M*CP) 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION A_0
      A_0 = A0
C
*     FUNCTION TR_0
      TR_0 = TR0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT
      FIT = (A0-A)/A0  
C
*     FUNCTION AFIT
      AFIT = A  
C
*     FUNCTION TRFIT
      TRFIT = TR
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
