C
C------------------------------------------------------
C
C     Problem:    HYDRODYN
C
C     Date:       12.02.99
C
C------------------------------------------------------
C      
*     REAL CONSTANT
      J = 0.5
      alpha = 0.1
      rho_bar = 3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      phi0, E0, phi, E, rho, x
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION phi_t
      phi_t = rho*E - alpha*J
C
*     FUNCTION E_t
      E_t = rho - 1
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_equ
      alg_equ = J**2 + rho**2 - phi*rho
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION phi_0
      phi_0 = phi0
C
*     FUNCTION E_0
      E_0 = E0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION rho_0
      rho_0 = 0.5*phi0 + sqrt(0.25*phi0**2 - J**2)
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION phi_fit
      phi_fit = phi
C
*     FUNCTION E_fit
      E_fit = E
C
*     FUNCTION rho_fit
      rho_fit = rho
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = rho - rho_bar
C
*     FUNCTION g2
      g2 = rho - rho_bar
C
*     FUNCTION g3
      g3 = 0.25*phi0**2 - J**2
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
