C
C------------------------------------------------------
C
C     Problem:    HYDRO
C
C     Date:       7.5.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      b = 5
      g = 9.81
      beta = 1
      c = 0.1
      w = 0.001
      Q0 = 1.65
      H0 = 1.2
C
C------------------------------------------------------
C
*     LININT input
         0.0    1.65
        20.0    50.0
        80.0    1.65 
      2000.0    1.65
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      par, Q, H, Q_x, H_x, Q_xx, H_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION Q_t
      if (H.lt.1.0E-10) then
        term = 0
        S = 0
      else
        A = b*H
        R = A/(b+2*H)
        S = c**2*abs(Q)*Q/(R**(4/3)*A**2) - w
        term = beta*(2*Q*Q_x/H - Q**2/H**2*H_x)/b
      endif
      Q_t = -par*g*b*H*(H_x + S) - term
C
*     FUNCTION H_t
      H_t = -Q_x/b
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION Q_0
      Q_0 = Q0
C
*     FUNCTION H_0
      H_0 = H0      
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION Q_left
      Q_left = input(t)
C
*     FUNCTION Q_right
      Q_right = b/c*(b*H/(b+2*H))**(2/3)*H*sqrt(w)
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit_Q
      fit_Q = Q
C
*     FUNCTION fit_H
      fit_H = H
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





