C
C------------------------------------------------------
C
C     Problem:     HYDENZYM
C
C     Date:        21.8.2000
C
C------------------------------------------------------
C
*     INDEX 
      k
C
C------------------------------------------------------
C
*     INTEGER CONSTANT
      maxiter = 100
C
C------------------------------------------------------
C
*     REAL CONSTANT
      p=0.25
      q=0.5
      r=0.25
      s=0.5
      ka = 0.213248
      kb = 0.204128
      kc = 0.211749
      kd = 0.209298
      ET = 1.0E-8
      eps = 1.0E-30
C
C------------------------------------------------------
C
*     LININT FT
      1.0  1.00E-03
      2.0  1.00E-03
      3.0  1.00E-03
      4.0  1.00E-03
      5.0  1.00E-03
      6.0  1.00E-03
      7.0  1.00E-03
      8.0  1.00E-03
      9.0  1.00E-03
      10.0  1.00E-03
      11.0  2.50E-03
      12.0  2.50E-03
      13.0  2.50E-03
      14.0  2.50E-03
      15.0  2.50E-03
      16.0  2.50E-03
      17.0  2.50E-03
      18.0  2.50E-03
      19.0  2.50E-03
      20.0  2.50E-03
      21.0  5.00E-03
      22.0  5.00E-03
      23.0  5.00E-03
      24.0  5.00E-03
      25.0  5.00E-03
      26.0  5.00E-03
      27.0  5.00E-03
      28.0  5.00E-03
      29.0  5.00E-03
      30.0  5.00E-03
      31.0  5.00E-03
      32.0  1.00E-02
      33.0  1.00E-02
      34.0  1.00E-02
      35.0  1.00E-02
      36.0  1.00E-02
      37.0  1.00E-02
      38.0  1.00E-02
      39.0  1.00E-02
      40.0  1.00E-02
      41.0  1.00E-02
      42.0  1.00E-02
C
*     LININT GT
      1.0  0.220
      2.0  0.400
      3.0  0.580
      4.0  0.820
      5.0  1.180
      6.0  1.600
      7.0  2.200
      8.0  2.980
      9.0  4.000
      10.0  5.980
      11.0  0.220
      12.0  0.400
      13.0  0.580
      14.0  0.820
      15.0  1.000
      16.0  1.420
      17.0  2.020
      18.0  2.980
      19.0  4.000
      20.0  5.020
      21.0  0.220
      22.0  0.400
      23.0  0.580
      24.0  0.820
      25.0  1.180
      26.0  1.780
      27.0  2.380
      28.0  3.220
      29.0  4.000
      30.0  5.020
      31.0  5.980
      32.0  0.220
      33.0  0.400
      34.0  0.580
      35.0  1.000
      36.0  1.600      
      37.0  2.620
      38.0  3.400
      39.0  4.180
      40.0  5.020
      41.0  5.980
      42.0  5.980
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      a, b, c, d, m, i
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION v
      En = ET
      Fn = FT(i)
      Gn = 0.2
      k=0
 1000 CONTINUE
      k=k+1
      if (En.lt.eps) then
        E = eps
      else
        E = En
      endif
      if (Fn.lt.eps) then
        F = eps
      else
        F = Fn
      endif
      if (Gn.lt.eps) then
        G = eps
      else
        G = Gn
      endif
      EpGa = ka**(1-p)*E**p*(G/ka)**a
      FqGb = kb**(1-q)*F**q*(G/kb)**b
      ErFsGc = kc**(1-r-s)*E**r*F**s*(G/kc)**c
      Gd = kd*(G/kd)**d
      En = E*sqrt(ET/abs(E + p*EpGa + r*ErFsGc))
      Fn = F*sqrt(FT(i)/abs(F + q*FqGb + s*ErFsGc))
      Gn = G*(GT(i)/(G + a*EpGa + b*FqGb + c*ErFsGc + d*Gd))
     /                                                  **(1/400) 
      if (k.lt.maxiter) then
        goto 1000
      endif
      v = m*1E10*ErFsGc
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


