C
C------------------------------------------------------
C
C     Problem:    HUMID
C
C     Date:       14.03.97
C
C------------------------------------------------------
C
*     PARAMETER
      NBREAKS = 5
C
C------------------------------------------------------
C
*     INDEX
      I
C
C------------------------------------------------------
C
*     SET OF INDICES
      IND_BREAKS = 1..NBREAKS
C
C------------------------------------------------------
C
*     REAL CONSTANT
      TFINAL = 0.6
      EPS=0.001
      L = 22700.0
      G = 0.0001603
      H = 0.008015
      HLAV = 0.8015
      KYAV = 0.06573
      CL = 18.0
      CPV = 7.3
      CPA = 7.3
      CVA = 5.3
      CVDP = 22700.0
      DHVAP = 9443.6
      P2 = KYAV/G
      P3 = HLAV/G
      P5 = HLAV/(CL*H)
      P6 = KYAV/(CL*H)
      YINI = 0.01
      TLINI = 43.33
      TGINI = 43.33
      V = 1
C
C------------------------------------------------------
C
*     TABLE TBREAK(J), J IN IND_BREAKS
      1  0.001
      2  0.04
      3  0.041
      4  0.048
      5  0.05
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      S, CVV, Y, TL, EV, YX, TLX, EVX, YXX, TLXX, EVXX, X, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION YP
      P4 = L/(H*S)
      Y1 = Y
      Y1X = YX
      IF (Y.LT.0.0) THEN
        Y1 = 0.0
        Y1X = 0.0
      ENDIF
      P1 = V/(G*S)
      TG = (EV - Y1*DHVAP)/(CVA + Y1*CVV)
      EP = CPA*TG + Y1*(CPV*TG + DHVAP)
      EXP1 = 7.96681 - 3002.4/(378.4 + 1.8*TL + 32.0)
      IF (EXP1.LT.20.0) THEN
        P = 10.0**EXP1
      ELSE 
        P = 10.0**10.0
      ENDIF
      YS = P/(760.0 - P)
      IF (YS.LT.0.0) THEN
         YS = 0.0
      ENDIF
      YP = -P1*Y1X + P2*(YS - Y1)
C
*     FUNCTION TLP
      P7 = CVV*TG + DHVAP
      TLP = P4*TLX - P5*(TL - TG) - P6*(YS - Y1)*P7
C
*     FUNCTION EVP
      TGX = (EVX - Y1X*DHVAP)/(CVA + Y1*CVV) -
     /         (EV - Y1*DHVAP)*Y1X*CVV/(CVA + Y1*CVV)**2
      EPX = CPA*TGX + Y1X*(CPV*TG + DHVAP)+ Y1*CPV*TGX
      EVP = -P1*EPX + P3*(TL - TG) + P2*(YS - Y1)*P7
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION Y0
      Y0 = YINI
C
*     FUNCTION TL0
      TL0 = TLINI
C
*     FUNCTION EV0
      EV0 = CVA*TGINI + YINI*(CVV*TGINI + DHVAP) 
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION TLR
      TLR = TLINI
C
C------------------------------------------------------
C
C   - Boundary and transition derivatives first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION YXL
      YXL = 0
C
*     FUNCTION EVXL
      EVXL = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION YFIT
      YFIT = Y
C
*     FUNCTION TLFIT
      TLFIT = TL
C
*     FUNCTION EVFIT
      EVFIT = EV
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
